
#include "TM1637.h"
#define CLK 3//pins definitions for TM1637 and can be changed to other ports       
#define DIO 4
TM1637 tm1637(CLK,DIO);
int8_t TubeTab[]= {0x00,0x00,0x00,0x00};
int state=0;
int IR1=5;
int IR2=6;
int IR3=7;
int count=0;
int fre_count=0;
void setup()
{
  tm1637.init();
  tm1637.set(BRIGHT_TYPICAL);//BRIGHT_TYPICAL = 2,BRIGHT_DARKEST = 0,BRIGHTEST = 7;
    pinMode(IR1,INPUT);
    pinMode(IR2,INPUT);
    pinMode(IR3,INPUT);
    Tubedisplay(count);
    attachInterrupt(0, displayclear, RISING );
}
void loop()
{
      if(digitalRead(IR1)==LOW || digitalRead(IR2)==LOW || digitalRead(IR3)==LOW)
     {
           delay(10);
           if(digitalRead(IR1)==HIGH && digitalRead(IR2)==HIGH && digitalRead(IR3)==HIGH)
           {
                count++;
            }
     }
     if(count != fre_count)
     {
          Tubedisplay(count);
     }
     fre_count=count;
}
void Tubedisplay(int temp)
{
      TubeTab[0]=temp/1000;
      TubeTab[1]=temp%1000/100;
      TubeTab[2]=temp%100/10;
      TubeTab[3]=temp%10;
      tm1637.display(TubeTab); 
}
void displayclear()
{
    count=0;
    Tubedisplay(count);
}
